/** An instance is a lexicographic pair (x, y) of 
   integers. Method compareTo defines the ordering:
   (x1,y1) < (x2, y2) iff (x1 < x2) or (x1 = x2 and y1 < y2) */
class Lexicographic implements Comparable {
   int x; 
   int y;
   
   /** Constructor: an instance with xp for x and yp for y */
   public Lexicographic(int xp, int yp) {
      x= xp;
      y= yp;
   }
   
   /** = 1 if this instance is > b, 0  if this instance = b,
         and -1 if this instance < b. It is assumed that b is
         actually of class Lexicographic */
   public int compareTo(Comparable b) {
      if (x < ((Lexicographic)b).x) return -1;
      if (x > ((Lexicographic)b).x) return 1;
      if (y < ((Lexicographic)b).y) return -1;
      if (y > ((Lexicographic)b).y) return 1;
      return 0;
   }
      
   /** =  a string representation (x,y) of this instance */
   public String toString() {
      return "(" + x + ", " + y + ")";
   }
}


